var examples = [
    {
        name: "Analog IO",
        vi: "Analog_IO_Example.vi",
        description: "This example will display and store the value of a single analog input. The most current analog input value will be displayed on the Front Panel of the VI. All analog input values will be stored in a .txt file in a location specified by the user.",
        type: "full"
    },
    {
        name: "Digital IO",
        vi: "Digital_IO_Example.vi",
        description: "This example allows the user to set digital outputs using the 'OP' command and read digital inputs using the 'TI' command. It will also poll the state of Digital Output 1. The most current digital I/O information will be displayed on the Front Panel of the VI in the form of a bit mask.",
        type: "full"
    },
    {
        name: "Data Record",
        vi: "Data_Record_Example.vi",
        description: "This example uses GRecord() to capture data record packets and then parses those packets into valuable information such as sample time (TIME), reference position (RP), and actual encoder position (TP). The most current values of each will be displayed on the Front Panel of the VI. Note, this example was written for the DMC-4000.",
        type: "full"
    },
    {
        name: "GArrayDownload",
        vi: "example_GArrayDownload.vi",
        description: "This example uses GArrayDownload() to download array elements to a Galil controller. The VI Front Panel gives users access to which array elements are downloaded to the controller.",
        type: "vi"
    },
    {
        name: "GArrayUpload",
        vi: "example_GArrayUpload.vi",
        description: "This example uses GArrayUpload() to upload array elements from a Galil controller. The VI Front Panel will display all array elements uploaded from the controller.",
        type: "vi"
    },
    {
        name: "GCommand",
        vi: "example_GCommand.vi",
        description: "This example uses GCommand() to send 'MG TIME' to query the value of the internal free running, real time clock. Users can send other DMC commands by altering the Front Panel of the example VI.",
        type: "vi"
    },
    {
        name: "GInterrupt",
        vi: "example_GInterrupt.vi",
        description: "This example uses GInterrupt() to pause code execution until a specified event has occurred. In this case, GInterrupt() pauses code execution until profiled motion is complete on Axis A. The user can define which event interrupts will hold up code execution using the EI/UI commands.",
        type: "vi"
    },
    {
        name: "GMessage",
        vi: "example_GMessage.vi",
        description: "This example shows users how to access unsolicited messages from a Galil controller using the GMessage() function. Unsolicited messages are messages that are generated by a DMC program running on the controller.",
        type: "vi"
    },
    {
        name: "GProgramDownload",
        vi: "example_GProgramDownload.vi",
        description: "This example uses GProgramDownload() to download a DMC program to a Galil controller. The VI Front Panel gives allows users to define the DMC program before downloading it to the controller.",
        type: "vi"
    },
    {
        name: "GProgramUpload",
        vi: "example_GProgramUpload.vi",
        description: "This example uses GProgramUpload() to upload a DMC program from a Galil controller. The VI Front Panel will display the DMC program uploaded from the controller.",
        type: "vi"
    },
    {
        name: "GRecord",
        vi: "example_GRecord.vi",
        description: "This example shows users how to access the data record from a Galil controller using the GRecord() function. This example gathers data record packets and then divides the packet into valuable information. For more information on the format of the data record packets from your controller, please check the controller's user manual.",
        type: "vi"
    },
    {
        name: "GArrayDownloadFile",
        vi: "example_GArrayDownloadFile.vi",
        description: "This example uses GArrayDownloadFile() to download array elements from a file to a Galil controller. The users should specify the path to the file in the VI Front Panel.",
        type: "vi"
    },
    {
        name: "GArrayUploadFile",
        vi: "example_GArrayUploadFile.vi",
        description: "This example uses GArrayUploadFile() to upload array elements to a file from a Galil controller. The users should specify the path to the file in the VI Front Panel.",
        type: "vi"
    },
    {
        name: "GMotionComplete",
        vi: "example_GMotionComplete.vi",
        description: "This example uses GMotionComplete to block program execution until motion is complete on the A axis. Once code execution resumes, another command is sent to the controller to confirm that the sequence has been completed.",
        type: "vi"
    },
    {
        name: "GProgramDownloadFile",
        vi: "example_GProgramDownloadFile.vi",
        description: "This example uses GProgramDownloadFile() to download a DMC program from a file location to a Galil controller. The VI Front Panel allows users to define the file path to the DMC program before before downloading to the controller.",
        type: "vi"
    },
    {
        name: "GProgramUploadFile",
        vi: "example_GProgramUploadFile.vi",
        description: "This example uses GProgramUploadFile() to upload a DMC program from a Galil controller. The VI Front Panel allows users to define the file path to the DMC program before uploading from the controller.",
        type: "vi"
    },
    {
        name: "GRecordRate",
        vi: "example_GRecordRate.vi",
        description: "This example uses GRecordRate() to set the asynchronous data record rate (in milliseconds) for the DR method of gathering data records. Once that is accomplished, this example gathers data record packets and then divides the packet into valuable information. For more information on the format of the data record packets from your controller, please check the controller's user manual.",
        type: "vi"
    },
    {
        name: "GTimeout",
        vi: "example_GTimeout.vi",
        description: "This example uses GTimeout() to set the timeout for for GInterrupt(). Once that is accomplished, This example uses GInterrupt() to pause code execution until profiled motion is complete on Axis A. The user can define which event interrupts will hold up code execution using the EI/UI commands.",
        type: "vi"
    }
];

function onLoad() {

    var full_examples_group = document.getElementById("full-examples-group");
    var vi_examples_group = document.getElementById("vi-examples-group");

    examples.forEach(element => {
        if(element.type == "full")
            full_examples_group.innerHTML += "<option value='" + element.vi + "'>" + element.name + "</option>";
    });

    examples.forEach(element => {
        if(element.type == "vi")
            vi_examples_group.innerHTML += "<option value='" + element.vi + "'>" + element.name + "</option>";
    });
    
    loadContent("getting-started");

    populateExample();
    standaloneDLLs();
}

function populateExample() {
    var examples_select = document.getElementById("examples-select");
    var version_select = document.getElementById("version-select");
    var version_number_text = document.getElementById("version-number-text");
    var example_path_text = document.getElementById("example-path-text");
    var example_description_text = document.getElementById("example-description");
    var example_title_text = document.getElementById("example-title");

    var example = examples.find(element => element.vi == examples_select.value);

    example_title_text.innerHTML = example.name;
    example_description_text.innerHTML = example.description;
    example_path_text.innerHTML = pathText();
    version_number_text.innerHTML = versionNumberText();

}

function versionNumberText() {
    var version_select = document.getElementById("version-select");
    var version_values = version_select.value.split("-");

    return "LabVIEW " + version_values[1] + " " + version_values[0] + "-bit";
}

function pathText() {
    var examples_select = document.getElementById("examples-select");
    var version_select = document.getElementById("version-select");
    var example = examples.find(element => element.vi == examples_select.value);

    var version_values = version_select.value.split("-");
    
    var path = "C:\\Program Files";
    if(version_values[0] == "32") {
        path += " (x86)";
    }
    path += "\\National Instruments\\LabVIEW " + version_values[1] + "\\vi.lib\\Galil\\examples\\" + example.type + "_examples\\" + example.vi;

    return path;
}

function loadContent(content_id)
{
    var content = document.getElementById("main-content");

    Array.from(content.children).forEach(element => {
        if(element.id == content_id)
            element.style.display = "block";
        else
            element.style.display = "none";
    });
}

function standaloneDLLs()
{
    var standalone_version_select = document.getElementById("standalone-version-select");
    var standalone_version_values = standalone_version_select.value.split("-");
    var dll_1 = document.getElementById("dll-1");
    var dll_2 = document.getElementById("dll-2");

    var path = "C:\\Program Files";
    if(standalone_version_values[0] == "32") {
        path += " (x86)";
    }
    path += "\\National Instruments\\LabVIEW " + standalone_version_values[1] + "\\vi.lib\\Galil\\resources\\dll\\";

    dll_1.innerHTML = path + "libcrypto-1_1";
    dll_2.innerHTML = path + "libssl-1_1";

    if(standalone_version_values[0] == "64") {
        dll_1.innerHTML += "-x64";
        dll_2.innerHTML += "-x64";
    }

    dll_1.innerHTML += ".dll";
    dll_2.innerHTML += ".dll";
}

window.onload = onLoad;

document.getElementById("examples-select").onchange = populateExample;
document.getElementById("version-select").onchange = populateExample;
document.getElementById("standalone-version-select").onchange = standaloneDLLs;

const link1 = document.getElementById("link1");
const link2 = document.getElementById("link2");
const link3 = document.getElementById("link3");
const content = document.querySelector(".content");

link1.addEventListener("click", function() {
    loadContent("getting-started");
});

link2.addEventListener("click", function() {
    loadContent("run-examples");
});

link3.addEventListener("click", function() {
    loadContent("build-standalone");
});