﻿Imports System.IO
Imports System.Threading
Module Module1
    Dim g As New Galil.Galil
    Sub Main()
        Try
            Dim fs As New FileStream("C:\infarray.txt", FileMode.Truncate) 'output file for the infinite array data
            'NOTE! Old data is overwritten with FileMode.Truncate

            Dim StartPointer As Integer = 0 'where data read begins via QU
            Dim EndPointer As Integer = -1 'where data read ends via QU
            Dim Recorded As Integer = 0 'keep track of points recorded
            Dim Delta As Integer = 0 'keep track of points read on each iteration
            Dim Response As String = "" 'to hold response to QU
            g.address = "192.168.142.3"
            Console.WriteLine(g.connection)
            g.command("ST")
            g.command("RC0")
            g.command("DA*[]")
            g.command("DM A[16000]")
            g.command("RA A[]")
            g.command("RD TIME") 'just record the TIME counter for this simple example
            g.command("TM125") 'aggressive TM, for recording at 4 Khz.
            g.command("RC 1,-16000") 'cicular array record. One sample per 250us based on TM above

            While (Console.KeyAvailable = False) 'exit with any key
                Thread.Sleep(50) 'sleep a bit, let the controller record some data to its array
                EndPointer = g.commandValue("MG_RD") 'get current recording location
                EndPointer -= 1 '_RD contains the address for the NEXT array element for recording. IT's not ready yet
                If (EndPointer = -1) Or (EndPointer < StartPointer) Then 'rollover
                    EndPointer = 15999
                End If

                Response = g.command("QU A[]," + StartPointer.ToString + "," + EndPointer.ToString + "{Z10.0}") 'go get the subset
                Dim data() As Byte = System.Text.Encoding.ASCII.GetBytes(Response) 'change it to byte stream
                fs.Write(data, 0, data.Count) 'write to file
                Delta = EndPointer - StartPointer 'calculate how many array points were just read
                Recorded += Delta 'accumulate for the global counter
                Console.WriteLine(Recorded.ToString + ", " + Delta.ToString)
                StartPointer = (EndPointer + 1) Mod 16000 'roll around with Modulo
            End While
            fs.Close()
            g.command("ST")
            g.command("RC0")
        Catch ex As Exception
            Console.WriteLine(ex.Message)
        End Try
        Console.ReadKey()
    End Sub
End Module
